/**
  ******************************************************************************
  * @file    optionbytes_interface.h
  * @author  MCD Application Team
  * @brief   Header for optionbytes_interface.c module
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef OPTIONBYTES_INTERFACE_H
#define OPTIONBYTES_INTERFACE_H

/* Includes ------------------------------------------------------------------*/
/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

void OPENBL_OB_Unlock(void);
void OPENBL_OB_Lock(void);
void OPENBL_OB_Launch(void);
void OPENBL_OB_Read(uint32_t Address, uint8_t *Data, uint32_t DataLength);
void OPENBL_OB_Write(uint32_t Address, uint8_t *Data, uint32_t DataLength);
void OPENBL_OB_SetReadOutProtectionLevel(uint32_t Level);
ErrorStatus OPENBL_OB_SetWriteProtection(FunctionalState State, uint8_t *ListOfPages, uint32_t Length);
uint32_t OPENBL_OB_GetReadOutProtectionLevel(void);

#endif /* OPTIONBYTES_INTERFACE_H */
